/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBWidgetMMediaCards = Object.create(STBModule.prototype);

STBWidgetMMediaCards.name = "WidgetMMediaCards";
STBWidgetMMediaCards.cardHeight = function(card ) {
	var max,
		nStateHeight = card.find(".normal-state").height();

	if (card.hasClass('with-flip')) {

		var bStateHeight = card.find(".back-state").height();

		max = Math.max(
			nStateHeight,
			bStateHeight
		);

	} else {
		max = nStateHeight;
	}

	return max;
}


STBWidgetMMediaCards.resizeCards = function() {
    try {
        var widgetCards = jQuery(".widget-cards:not(.__done)");
        widgetCards.each(function () {

            var row = jQuery(this).find(".row"),
                cards = row.find(".card-holder"),
                cardsLnt = cards.length,
                maxHeight = 0,
                sh = row.hasClass('static-height'),
                j = 0;

            var pos = 0;

            if (row.hasClass('cards-align-bottom')) {
                pos = 1;
            }

            if (row.hasClass('cards-align-middle')) {
                pos = 2;
            }

            if (sh) {
                for (j; j < cardsLnt; j++) {
                    maxHeight = Math.max(STBWidgetMMediaCards.cardHeight(jQuery(cards[j])), maxHeight);
                }

                maxHeight = parseInt(maxHeight);
            }

            if (cardsLnt > 0) {
                var parseCards = function () {

                    var elem = jQuery(this),
                        state = elem.find(".state"),
                        stateLnt = state.length;

                    if (sh === false) {

                        maxHeight = STBWidgetMMediaCards.cardHeight(elem);
                    }

                    elem.css("minHeight", maxHeight + 'px');

                    if (stateLnt > 0) {
                        var parseState = function () {

                            var objState = jQuery(this);

                            objState.css("minHeight", maxHeight + "px");
                        };

                        state.each(parseState);
                    }
                };

                cards.each(parseCards);
            }

            if (row.hasClass('cards-masonry')) {

                row.prepend("<div class=\"" + row.attr("data-sizer") + "\"></div>");

                row.isotope({
                    itemSelector: '.cards-masonry-element',
                    percentPosition: true,
                    masonry: {
                        columnWidth: '.' + row.attr("data-sizer")
                    }
                });
            }

			jQuery(this).addClass("__done");
        });


    } catch (e) {
        getStack(0, e);
    }
}

STBWidgetMMediaCards.initCards = function() {
    try {
        var widgetCards = jQuery(".widget-cards");

        if (widgetCards.length > 0) {

            var i = 0,
                insideState = widgetCards.find('.inside-state'),
                link = widgetCards.find('.card-link'),
                pTop = insideState.first().css("padding-top").replace("px", ""),
                pBottom = insideState.first().css("padding-bottom").replace("px", "");

            if (link.length > 0) {
                for (i; i < link.length; i++) {
                    if (link[i].innerHTML === "") {
                        link[i].remove();
                    }
                }
            }

            widgetCards.imagesLoaded(STBWidgetMMediaCards.resizeCards);
        }

    } catch (e) {
        getStack(0, e);
    }
}


STBWidgetMMediaCards.runOnReady = function() {
	STBWidgetMMediaCards.initCards();
}

STBWidgetMMediaCards.runOnResize = function() {
    var widgetCards = jQuery('.widget-cards'),
        holder = widgetCards.find('.card-holder'),
        state = widgetCards.find('.state');

        holder.css("min-height", "0");
        state.css({"min-height": "0", "padding-top": "0"});
		widgetCards.removeClass("__done");

	STBWidgetMMediaCards.initCards();
}

STBWidgetMMediaCards.runOnContentUpdate = function() {
	STBWidgetMMediaCards.initCards();
}



site.registerModule(STBWidgetMMediaCards);